﻿using System;

namespace Kinematics
{
    public class JointObject
    {
        public double Alpha { get; set; }
        public double A { get; set; }
        public double Theta { get; set; }
        public double D { get; set; }

        public JointObject()
        {
        }

        public JointObject(double alpha, double a, double theta, double d)
        {
            Alpha = alpha;
            A = a;
            Theta = theta;
            D = d;
        }

        public double[,] GetArray()
        {
            double[,] array = new double[4, 4];
            array[0,0] = Math.Cos(Theta * (Math.PI / 180.0f));
            array[0,1] = -1 * Math.Cos(Alpha * (Math.PI / 180.0f)) * Math.Sin(Theta * (Math.PI / 180.0f));
            array[0,2] = Math.Sin(Alpha * (Math.PI / 180.0f)) * Math.Sin(Theta * (Math.PI / 180.0f));
            array[0,3] = A * Math.Cos(Theta * (Math.PI / 180.0f));
            array[1,0] = Math.Sin(Theta * (Math.PI / 180.0f));
            array[1,1] = Math.Cos(Theta * (Math.PI / 180.0f)) * Math.Cos(Alpha * (Math.PI / 180.0f));
            array[1,2] = -1 * Math.Sin(Alpha * (Math.PI / 180.0f)) * Math.Cos(Theta * (Math.PI / 180.0f));
            array[1,3] = A * Math.Sin(Theta * (Math.PI / 180.0f));
            array[2,0] = 0;
            array[2,1] = Math.Sin(Alpha * (Math.PI / 180.0f));
            array[2,2] = Math.Cos(Alpha * (Math.PI / 180.0f));
            array[2,3] = D;
            array[3,0] = 0;
            array[3,1] = 0;
            array[3,2] = 0;
            array[3,3] = 1;
            return array;
        }
    }
}
